function body = createAirDragCurve(body)

switch body.class
    case "RigidTruck"
        delta_CdA_coeffs = [-0.000666   0.017746    0.013526    0];
    case "Tractor"
        delta_CdA_coeffs = [-0.002130   0.040817    0.030042    0];
    % case "RigidTrailer"
    %     delta_CdA_coeffs = [-0.004148   0.072275    0.017125    0];
    % case "Bus"
    %     delta_CdA_coeffs = [-0.000794   0.021090    -0.001090    0];
    case "LightDuty"
        % Create a dummy interpolant
        body.CdA = griddedInterpolant([0, 300/3.6], [body.CdA, body.CdA], 'nearest');
        return
end

% Reference data
refHeight = 4; % m
refWindSpd = 3; % m/s
vehHeight = 4; % m, reference value for Groups 4-17
% Declared CdA
CdA0 = body.CdA;

%% Evaluate CdA as a function of vehSpd
vehSpdVec = (60:5:130)' ./ 3.6;

height_0 = 0.05 * vehHeight;
height_f = vehHeight;

alpha_0 = 0;
alpha_f = 180;

windSpd = @(height) refWindSpd .* ( height ./ refHeight ).^(0.2);

airSpd_x = @(vehSpd, height, alpha) windSpd(height) .* cosd(alpha) + vehSpd;
airSpd_y = @(vehSpd, height, alpha) windSpd(height) .* sind(alpha);

airSpd = @(vehSpd, height, alpha) sqrt( airSpd_x(vehSpd, height, alpha).^2 + airSpd_y(vehSpd, height, alpha).^2 );
beta = @(vehSpd, height, alpha) atand( airSpd_y(vehSpd, height, alpha) ./ airSpd_x(vehSpd, height, alpha) );

CdA_beta = @(vehSpd, height, alpha) CdA0 + polyval( delta_CdA_coeffs, beta(vehSpd, height, alpha) );

CdA = zeros(size(vehSpdVec));
for n = 1:length(vehSpdVec)
    vehSpd = vehSpdVec(n);
    integrand = @(height, alpha) CdA_beta(vehSpd, height, alpha) .* airSpd(vehSpd, height, alpha).^2;
    CdA(n) = integral2( integrand, height_0, height_f, alpha_0, alpha_f ) ./ ( (height_f - height_0) * (alpha_f - alpha_0) * vehSpd.^2);
end

%% Create interpolant CdA(vehSpd)
% Extend solution to [0, 300] km/h
vehSpdVec = [0; vehSpdVec; 300/3.6];
CdA = [CdA(1); CdA; CdA(end)];
% Create interpolant
body.CdA = griddedInterpolant(vehSpdVec, CdA);

end